<?php
/*****************************************************************/
/* PHP Mini Proxy, v1.1, Copyright ABYSS Corporation, 2009       */
/* Author: Dodot <dodot@abysscorp.org>                           */
/* Released under GNU General Public License, version 3 or later */
/* See http://www.gnu.org/copyleft/gpl.html                      */
/*****************************************************************/
/* Features:                                                     */
/* - Lightweight and fast HTTP proxy                             */
/* - Finds and replaces URLs in HTML, CSS, Javascript for a      */
/*   transparent navigation from page to page                    */
/* - Forwards any content type                                   */
/* - URLs are encoded using base64                               */
/* New since version 1.1:                                        */
/* - Forms and cookies are forwarded too (still not perfect)     */
/* - Added the dumb URL replacer (disabled)                      */
/*****************************************************************/
/* Known problems:                                               */
/* - Continuous streams don't work (i.e. Flash streams)          */
/* - URLs in Javascript cannot always be found                   */
/*****************************************************************/

/* Configuration */
$startup_form = 'startup.php';
$pmp_filename = ''; // name of this file, can be empty if index.php
$webtoolkit_path = ''; // path of webtoolkit library for base64
$dumb_url_replacer = false; // for testing only

/*****************************************************************/
/* Do not modify below unless you know what you're doing         */
/*****************************************************************/
if (!isset($_GET['pmpurl']))
{
	include($startup_form);
}
else
{
	if (isset($_GET['pmpurl']))
		$url = decodeURL($_GET['pmpurl']);
	else die('Internal error: No URL found in GET query');
	
	// append http:// if necessary
	if (strtolower(substr($url, 0, 4)) <> 'http')
		$url = 'http://'.$url;

	// root address extraction to complete relative URLs
	$root = urlPathName($url);
		
	// load the url
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_HEADER, true);
	curl_setopt($ch, CURLOPT_CRLF, true);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	if (!empty($_COOKIE))
	{
		// cookies forwarding from browser to destination site
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Cookie: '.http_build_query_ex($_COOKIE, null, '; ')));
	}
	if (!empty($_POST))
	{
		// form forwarding from browser to destination site
		curl_setopt($ch, CURLOPT_POST, 1);
		if (isset($_SERVER['CONTENT_TYPE']) && (stristr($_SERVER['CONTENT_TYPE'], 'multipart/form-data') !== false))
			curl_setopt($ch, CURLOPT_POSTFIELDS, $_POST); // use of multipart/form-data (see curl_setopt comments)
		else		
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query_ex($_POST)); // use of x-www-form-urlencoded
	}
	$data = curl_exec($ch);
	
	// separation of header and document
	list($header, $doc) = explode("\r\n\r\n", $data, 2);
	
	// location forwarding
	if (preg_match('/Location:\s*([^\s\r\n]*)/i', $header, $location_results))
	{
		$url = $pmp_filename.'?pmpurl='.encodeURL(absoluteURL($location_results[1]));
		if ($google_ad) $url .= '&pmpad=1';
		header('Location: '.$url);
	}
	// cookies forwarding from the website to the browser (broken)
	$nbcookies = preg_match_all('/Set-Cookie:\s*([^;=\r\n]*)=([^;\r\n]*)/i', $header, $setcookie_results);
	for ($i = 0; $i < $nbcookies; $i++)
		setcookie($setcookie_results[1][$i], $setcookie_results[2][$i], time() + 3600);
	
	$result = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	// if http result OK
	if ($result == 200)
	{
		// content-type forwarding
		$full_content_type = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
		header('Content-Type: '.$full_content_type);
		// content-type decoding
		$content_type = explode(';', $full_content_type);
		if (is_array($content_type) && !empty($content_type))
			$content_type = $content_type[0];
		// if document is html
		if ($content_type == 'text/html' || $content_type == 'text/xhtml' || $content_type == 'text/xml')
		{
			// replace urls in the document
			// replace "src=" links
			$doc = preg_replace_callback('/\ssrc=([\\]?[\'"]?([^\s<>\'"]+)[\\]?[\'"]?)/im', 'replace_src', $doc);
			// replace "href=" links
			$doc = preg_replace_callback('/\shref=([\\]?[\'"]?([^\s<>\'"]+)[\\]?[\'"]?)/im', 'replace_href', $doc);
			// replace "action=" links
			$doc = preg_replace_callback('/\saction=([\\]?[\'"]?([^\s<>\'"]+)[\\]?[\'"]?)/im', 'replace_action', $doc);
			// replace CSS "url()" links
			$doc = preg_replace_callback('/url\(([\'"]?([^\)\s\'"]*)[\'"]?)\)/im', 'replace_url', $doc);
			// replace anything that looks like an URL (might break result)
			if ($dumb_url_replacer)
			{
				$doc = preg_replace_callback('|([^\w](https?://[\w:/.?=&+-;%]+))|', 'replace_dumb', $doc);
			}
		}
		// if document is css
		elseif ($content_type == 'text/css')
		{
			// replace CSS "url()" links
			$doc = preg_replace_callback('/url\(([\'"]?([^\)\s\'"]*)[\'"]?)\)/im', 'replace_url', $doc);
		}

		echo $doc;
	}
	// if http result not OK, show error code
	else
	{
		header('Content-Type: text/plain');
		echo "PHP Mini Proxy failed to load your page, sorry :(\r\n";
		echo "CURL returned error code ".$result;
		echo " (URL: ".$url.")\r\n";
		echo "CURL said: ".curl_error($ch)."\r\n\r\n";
		if (!empty($data))
			echo $data;
	}

	curl_close($ch);
}

// extracts the complete url path
function urlPathName($url)
{
	$pathName = $url;
	$url_info = parse_url($url);

	if (isset($url_info['host']) && ($url_info['host'] != ''))
	{
		$host = $url_info['host'];
		if (isset($url_info['scheme']) && ($url_info['scheme'] != ''))
			$scheme = $url_info['scheme'];
		else
			$scheme = 'http';
		if (isset($url_info['port']) && ($url_info['port'] != ''))
			$port = ':'.$url_info['port'];
		elseif ($scheme == 'https')
			$port = ':443';
		else
			$port = '';
		if (isset($url_info['path']) && ($url_info['path'] != ''))
			$path = trim(dirname($url_info['path']), '/\\');

		if (isset($path) && $path != '')
			$pathName = $scheme.'://'.$host.$port.'/'.$path;
		else
			$pathName = $scheme.'://'.$host.$port;
	}

	return $pathName;
}

// encodes an URL using modified base 64
function encodeURL($url)
{
	return strtr(base64_encode($url),'=/','-_');
}

// decodes an URL using modified base 64
function decodeURL($url)
{
	return base64_decode(strtr($url, '-_', '=/'));
}

// builds an absolute url from a relative one
function absoluteURL($path)
{
	global $root;

	if (preg_match('|^\w+://|',$path))
		return $path;
	else
		return $root.'/'.ltrim($path, '/');
}

function http_build_query_ex($data, $prefix=null, $sep='', $key='')
{
	$ret = array();
	foreach((array)$data as $k => $v)
	{
		$k = urlencode($k);
		if(is_int($k) && $prefix != null)
			$k = $prefix.$k;
		if(!empty($key))
			$k = $key."[".$k."]";

		array_push($ret,$k."=".urlencode($v));
	}

	if(empty($sep))
		$sep = ini_get("arg_separator.output");

	return implode($sep, $ret);
}

// functions used to replace URLs in documents

function replace_src($matches)
{
	global $pmp_filename;
	$url = $pmp_filename.'?pmpurl='.encodeURL(absoluteURL($matches[2]));
	return ' src='.str_replace($matches[2], $url, $matches[1]);
}

function replace_href($matches)
{
	global $pmp_filename, $google_ad;
	$url = $pmp_filename.'?pmpurl='.encodeURL(absoluteURL($matches[2]));
	return ' href='.str_replace($matches[2], $url, $matches[1]);
}

function replace_url($matches)
{
	global $pmp_filename;
	$url = $pmp_filename.'?pmpurl='.encodeURL(absoluteURL($matches[2]));
	return ' url('.str_replace($matches[2], $url, $matches[1]).')';
}

function replace_action($matches)
{
	global $pmp_filename;
	$url = $pmp_filename.'?pmpurl='.encodeURL(absoluteURL($matches[2]));
	return ' action='.str_replace($matches[2], $url, $matches[1]);
}

function replace_dumb($matches)
{
	global $pmp_filename;
	$url = $pmp_filename.'?pmpurl='.encodeURL($matches[2]);
	return str_replace($matches[2], $url, $matches[1]);
}

?>